<?php
/*
//(C) OXID-Design 2017
//
// The source contained in this file is the property of the OXID-Design
// (Leipziger Allee 36, 76139 Karlsruhe, Germany, www.oxid-design.com).
//
// GNU GENERAL PUBLIC LICENSE
//
//This program is free software;
//you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation;
//either version 3 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
// You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>
*/

class od_flow_cat extends od_flow_cat_parent {
    public function render() {
        parent::render();
        $this->_aViewData['edit'] = $oCategory = oxNew('oxcategory');
        $soxId = $this->_aViewData["oxid"] = $this->getEditObjectId();
        if ($soxId != "-1" && isset($soxId)) {
            // load object
            $iCatLang = oxRegistry::getConfig()->getRequestParameter("catlang");
            if (!isset($iCatLang)) {
                $iCatLang = $this->_iEditLang;
            }
            $this->_aViewData["catlang"] = $iCatLang;

            $oCategory->loadInLang($iCatLang, $soxId);
            foreach (oxRegistry::getLang()->getLanguageNames() as $id => $language) {
                $oLang = new stdClass();
                $oLang->sLangDesc = $language;
                $oLang->selected = ($id == $this->_iEditLang);
                $this->_aViewData["otherlang"][$id] = clone $oLang;
            }
        }
        $this->_aViewData["editor"] = $this->_generateTextEditor("100%", 300, $oCategory, "oxcategories__oxlongdesc", "list.tpl.css");
        $this->_aViewData["editorb"] = $this->_generateTextEditor("100%", 300, $oCategory, "oxcategories__oxlongdescb", "list.tpl.css");

        return "od_flow_cat.tpl";
    }
}
